--[[
DewDropDown.lua
Defines the table listings for the dropdown lists.
]]

--Invoke all libraries
local BabbleBoss = LibStub("LibBabble-Boss-3.0"):GetLookupTable();
local BabbleZone = LibStub("LibBabble-Zone-3.0"):GetLookupTable();
local BabbleFaction = LibStub("LibBabble-Faction-3.0"):GetLookupTable();
local BabbleClass = LibStub("LibBabble-Class-3.0"):GetLookupTable();
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

--This is a multi-layer table defining the main loot listing.
--Entries have the text to display, loot table or sub table to link to and if the link is to a loot table or sub table
AtlasLoot_DewDropDown = {
	[1] = {
		[AL["Classic Instances"]] = {
			[1] = { 
				{ BabbleZone["Blackfathom Deeps"], "BlackfathomDeeps", "Submenu" },
			},
			[2] = { 
				{ BabbleZone["Blackrock Depths"], "BlackrockDepths", "Submenu" },
			},
			[3] = { 
				{ BabbleZone["Lower Blackrock Spire"], "LowerBlackrock", "Submenu" },
			},
			[4] = { 
				{ BabbleZone["Upper Blackrock Spire"], "UpperBlackrock", "Submenu" },
			},
			[5] = { 
				{ BabbleZone["Blackwing Lair"], "BlackwingLair", "Submenu" },
			},
			[6] = { 
				{ BabbleZone["The Deadmines"], "Deadmines", "Submenu" },
			},
			[7] = { 
				[BabbleZone["Dire Maul"]] = {
					{ BabbleZone["Dire Maul (East)"], "DireMaulEast", "Submenu" },
					{ BabbleZone["Dire Maul (West)"], "DireMaulWest", "Submenu" },
					{ BabbleZone["Dire Maul (North)"], "DireMaulNorth", "Submenu" },
				}, 
			},
			[8] = { 
				{ BabbleZone["Gnomeregan"], "Gnomeregan", "Submenu" },
			},
			[9] = { 
				{ BabbleZone["Maraudon"], "Maraudon", "Submenu" },
			},
			[10] = { 
				{ BabbleZone["Molten Core"], "MoltenCore", "Submenu" },
			},
			[11] = { 
				{ BabbleZone["Naxxramas"], "Naxxramas", "Submenu" },
			},
			[12] = { 
				{ BabbleZone["Onyxia's Lair"], "Onyxia", "Submenu" },
			},
			[13] = { 
				{ BabbleZone["Ragefire Chasm"], "RagefireChasm", "Table" },
			},
			[14] = { 
				{ BabbleZone["Razorfen Downs"], "RazorfenDowns", "Submenu" },
			},
			[15] = { 
				{ BabbleZone["Razorfen Kraul"], "RazorfenKraul", "Submenu" },
			},
			[16] = { 
				{ BabbleZone["Ruins of Ahn'Qiraj"], "RuinsofAQ", "Submenu" },
			},
			[17] = { 
				{ BabbleZone["Scarlet Monastery"], "Scarlet Monastery", "Submenu" },
			},
			[18] = { 
				{ BabbleZone["Scholomance"], "Scholomance", "Submenu" },
			},
			[19] = { 
				{ BabbleZone["Shadowfang Keep"], "ShadowfangKeep", "Submenu" },
			},
			[20] = { 
				{ BabbleZone["The Stockade"], "TheStockade", "Table" },
			},
			[21] = { 
				{ BabbleZone["Stratholme"], "Stratholme", "Submenu" },
			},
			[22] = { 
				{ BabbleZone["Temple of Ahn'Qiraj"], "TempleofAQ", "Submenu" },
			},
			[23] = { 
				{ BabbleZone["The Temple of Atal'Hakkar"], "SunkenTemple", "Submenu" },
			},
			[24] = { 
				{ BabbleZone["Uldaman"], "Uldaman", "Submenu" },
			},
			[25] = { 
				{ BabbleZone["Wailing Caverns"], "WailingCaverns", "Submenu" },
			},
			[26] = { 
				{ BabbleZone["Zul'Farrak"], "ZulFarrak", "Submenu" },
			},
			[27] = { 
				{ BabbleZone["Zul'Gurub"], "ZulGurub", "Submenu" },
			},
		},
	},
	[2] = {
		[AL["BC Instances"]] = {
			[1] = { 
				[BabbleZone["Auchindoun"]] = {
					{ BabbleZone["Mana-Tombs"], "AuchManaTombs", "Submenu" },
					{ BabbleZone["Auchenai Crypts"], "AuchCrypts", "Submenu" },
					{ BabbleZone["Sethekk Halls"], "AuchSethekk", "Submenu" },
					{ BabbleZone["Shadow Labyrinth"], "AuchShadowLab", "Submenu" },
				}, 
			},
			[2] = { 
				{ BabbleZone["Black Temple"], "BlackTemple", "Submenu" },
			},
			[3] = {
				[BabbleZone["Caverns of Time"]] = {
					{ BabbleZone["Old Hillsbrad Foothills"], "CoTOldHillsbrad", "Submenu" },
					{ BabbleZone["The Black Morass"], "CoTBlackMorass", "Submenu" },
					{ BabbleZone["Hyjal Summit"], "CoTHyjal", "Submenu" },
				}, 
			},
			[4] = { 
				[BabbleZone["Coilfang Reservoir"]] = {
					{ BabbleZone["The Slave Pens"], "CFRSlavePens", "Submenu" },
					{ BabbleZone["The Underbog"], "CFRUnderbog", "Submenu" },
					{ BabbleZone["The Steamvault"], "CFRSteamvault", "Submenu" },
					{ BabbleZone["Serpentshrine Cavern"], "CFRSerpentshrine", "Submenu" },
				}, 
			},
			[5] = { 
				{ BabbleZone["Gruul's Lair"], "Gruul", "Submenu" },
			},
			[6] = { 
				[BabbleZone["Hellfire Citadel"]] = {
					{ BabbleZone["Hellfire Ramparts"], "HCRamparts", "Submenu" },
					{ BabbleZone["The Blood Furnace"], "HCFurnace", "Submenu" },
					{ BabbleZone["The Shattered Halls"], "HCShatteredHalls", "Submenu" },
					{ BabbleZone["Magtheridon's Lair"], "HCMagLair", "Submenu" },
				}, 
			},
			[7] = { 
				{ BabbleZone["Karazhan"], "Karazhan", "Submenu" },
			},
			[8] = { 
				{ BabbleZone["Magisters' Terrace"], "MagistersTerrace", "Submenu" },
			},
			[9] = { 
				{ BabbleZone["Sunwell Plateau"], "SunwellPlateau", "Submenu" },
			},
			[10] = { 
				[BabbleZone["Tempest Keep"]] = {
					{ BabbleZone["The Mechanar"], "TKMech", "Submenu" },
					{ BabbleZone["The Botanica"], "TKBot", "Submenu" },
					{ BabbleZone["The Arcatraz"], "TKArc", "Submenu" },
					{ BabbleZone["The Eye"], "TKEye", "Submenu" },
				}, 
			},
			[11] = { 
				{ BabbleZone["Zul'Aman"], "ZulAman", "Submenu" },
			},
		},
	},
	[3] = {
		[AL["Crafting"]] = {
			[1] = { { (GetSpellInfo(2259)), "Alchemy", "Submenu" }, },
			[2] = { { (GetSpellInfo(2018)), "BlackSmithing", "Submenu" }, },
			[3] = { { (GetSpellInfo(2550)), "Cooking", "Submenu" }, },
			[4] = { { (GetSpellInfo(7411)), "Enchanting", "Submenu" }, },
			[5] = { { (GetSpellInfo(4036)), "Engineering", "Submenu" }, },
			[6] = { { (GetSpellInfo(3273)), "FirstAid1", "Table" }, },
			[7] = { { (GetSpellInfo(25229)), "Jewelcrafting", "Submenu" }, },
			[8] = { { (GetSpellInfo(2108)), "Leatherworking", "Submenu" }, },
			[9] = { { (GetSpellInfo(2575)), "Mining1", "Table" }, },
			[10] = { { (GetSpellInfo(3908)), "Tailoring", "Submenu" }, },
			[11] = { 
				[AL["Crafted Sets"]] = {
					{ (GetSpellInfo(2018)), "CraftSetBlacksmith", "Submenu" },
					{ (GetSpellInfo(2108)), "CraftSetLeatherwork", "Submenu" },
					{ (GetSpellInfo(3908)), "CraftSetTailor", "Submenu" },
				}, 
			},
			[12] = { { AL["Crafted Epic Weapons"], "CraftedWeapons1", "Table" }, },
		},
	},
	[4] = {
		[AL["Sets/Collections"]] = {
			[1] = { 
				{ AL["Pre 60 Sets"], "Pre60Sets", "Submenu" },
			},
			[2] = { 
				{ AL["Zul'Gurub Sets"], "ZGSets", "Submenu" },
			},
			[3] = { 
				{ AL["Ruins of Ahn'Qiraj Sets"], "AQ20Sets1", "Table" },
			},
			[4] = { 
				{ AL["Temple of Ahn'Qiraj Sets"], "AQ40Sets1", "Table" },
			},
			[5] = { 
				{ AL["Dungeon 1/2 Sets"], "DungeonSets12", "Submenu" },
			},
			[6] = { 
				{ AL["Dungeon 3 Sets"], "DungeonSets3", "Submenu" },
			},
			[7] = { 
				{ AL["Tier 1/2 Sets"], "T1T2Sets", "Submenu" },
			},
			[8] = { 
				{ AL["Tier 3 Sets"], "T3Sets", "Submenu" },
			},
			[9] = { 
				{ AL["Tier 4 Sets"], "T4Sets", "Submenu" },
			},
			[10] = { 
				{ AL["Tier 5 Sets"], "T5Sets", "Submenu" },
			},
			[11] = { 
				{ AL["Tier 6 Sets"], "T6Sets", "Submenu" },
			},
			[12] = {
				{ AL["BoE World Epics"], "BoEWorldEpics", "Submenu" },
			},
			[13] = {
				{ AL["Badge of Justice Rewards"], "Lvl70TokenRewards", "Submenu" },
			},
			[14] = { { AL["Legendary Items"], "Legendaries", "Table" }, },

			[15] = { { AL["Rare Mounts"], "RareMounts1", "Table" }, },

			[16] = { { AL["Tabards"], "Tabards1", "Table" }, },
			[17] = { { AL["Upper Deck Card Game Items"], "CardGame1", "Table" }, },
		},
	},
	[5] = {
		[AL["PvP Rewards"]] = {
			[1] = { 
				{ AL["Arena PvP Sets"], "ArenaPvPRewards", "Submenu" },
			},
			[2] = { 
				{ AL["Arena 2 PvP Sets"], "Arena2PvPRewards", "Submenu" },
			},
			[3] = { 
				{ AL["Arena 3 PvP Sets"], "Arena3PvPRewards", "Submenu" },
			},
			[4] = { 
				{ AL["Arena 4 PvP Sets"], "Arena4PvPRewards", "Submenu" },
			},
			[5] = { 
				{ AL["PvP Rewards (Level 60)"], "PvPLvl60Rewards", "Submenu" },
			},
			[6] = { 
				{ AL["PvP Rewards (Level 70)"], "PvPLvl70Rewards", "Submenu" },
			},
			[7] = { 
				{ AL["PvP Non-Set Epics"], "PvPNonSetEpic", "Submenu" },
			},
			[8] = { 
				{ BabbleZone["Alterac Valley"], "AVRewards", "Submenu" },
			},
			[9] = { 
				{ BabbleZone["Arathi Basin"], "ABRewards", "Submenu" },
			},
			[10] = { 
				{ AL["Arathi Basin Sets"], "ABSets", "Submenu" },
			},
			[11] = { 
				{ BabbleZone["Warsong Gulch"], "WSGRewards", "Submenu" },
			},
			[12] = { { AtlasLoot_TableNames["Hellfire"][1], "Hellfire", "Table" }, },
			[13] = { { AtlasLoot_TableNames["Nagrand1"][1], "Nagrand1", "Table" }, },
			[14] = { { AtlasLoot_TableNames["Terokkar"][1], "Terokkar", "Table" }, },
			[15] = { { AtlasLoot_TableNames["Zangarmarsh"][1], "Zangarmarsh", "Table" }, },
		},
	},
	[6] = {
		{ AL["World Bosses"], "WorldBosses", "Submenu" },
	},
	[7] = {
		{ AL["Reputation Factions"], "Factions", "Submenu" },
	},
	[8] = {
		[AL["World Events"]] = {
			[1] = { 
				{ AL["Abyssal Council"], "AbyssalCouncil", "Submenu" },
			},
			[2] = { 
				{ AL["Bash'ir Landing Skyguard Raid"], "BashirLanding", "Table" },
			},
			[3] = { 
				{ AL["Brewfest"], "Brewfest1", "Table" },
			},
			[4] = { 
				{ AL["Children's Week"], "ChildrensWeek", "Table" },
			},
			[5] = { 
				{ AL["Elemental Invasion"], "ElementalInvasion", "Table" },
			},
			[6] = { 
				{ AL["Ethereum Prison"], "EthereumPrison", "Submenu" },
			},
			[7] = { 
				{ AL["Feast of Winter Veil"], "Winterviel1", "Table" },
			},
			[8] = { 
				{ AL["Gurubashi Arena Booty Run"], "GurubashiArena", "Table" },
			},
			[9] = { 
				{ AL["Hallow's End"], "Halloween1", "Table" },
			},
			[10] = { 
				{ AL["Harvest Festival"], "HarvestFestival", "Table" },
			},
			[11] = { 
				{ AL["Love is in the Air"], "Valentineday", "Table" },
			},
			[12] = { 
				{ AL["Lunar Festival"], "LunarFestival1", "Table" },
			},
			[13] = { 
				{ AL["Midsummer Fire Festival"], "MidsummerFestival", "Table" },
			},
			[14] = { 
				{ AL["Noblegarden"], "Noblegarden", "Table" },
			},
			[15] = { 
				{ AL["Scourge Invasion"], "ScourgeInvasionEvent1", "Table" },
			},
			[16] = { 
				{ AL["Shartuul"], "Shartuul", "Table" },
			},
			[17] = { 
				{ AL["Skettis"], "Skettis", "Submenu" },
			},
			[18] = { 
				{ AL["Stranglethorn Fishing Extravaganza"], "FishingExtravaganza", "Table" },
			},
		},
	},
};

--This table defines all the subtables needed for the full menu
--Each sub table entry contains the text entry and the loot table that goes wih it
AtlasLoot_DewDropDown_SubTables = {
	["BlackrockDepths"] = {
		{ AtlasLoot_TableNames["BRDPyron"][1], "BRDPyron" },
		{ BabbleBoss["Lord Roccor"], "BRDLordRoccor" },
		{ BabbleBoss["High Interrogator Gerstahn"], "BRDHighInterrogatorGerstahn" },
		{ AtlasLoot_TableNames["BRDArena"][1], "BRDArena" },
		{ AL["Theldren"], "BRDTheldren" },
		{ BabbleBoss["Houndmaster Grebmar"], "BRDHoundmaster" },
		{ BabbleBoss["Pyromancer Loregrain"], "BRDPyromantLoregrain" },
		{ AL["The Vault"], "BRDTheVault" },
		{ BabbleBoss["Warder Stilgiss"], "BRDWarderStilgiss" },
		{ BabbleBoss["Verek"], "BRDVerek" },
		{ BabbleBoss["Fineous Darkvire"], "BRDFineousDarkvire" },
		{ BabbleBoss["Lord Incendius"], "BRDLordIncendius" },
		{ BabbleBoss["Bael'Gar"], "BRDBaelGar" },
		{ BabbleBoss["General Angerforge"], "BRDGeneralAngerforge" },
		{ BabbleBoss["Golem Lord Argelmach"], "BRDGolemLordArgelmach" },
		{ AtlasLoot_TableNames["BRDGuzzler"][1], "BRDGuzzler" },
		{ AL["Coren Direbrew"], "CorenDirebrew" },
		{ BabbleBoss["Ambassador Flamelash"], "BRDFlamelash" },
		{ BabbleBoss["Panzor the Invincible"], "BRDPanzor" },
		{ AtlasLoot_TableNames["BRDTomb"][1], "BRDTomb" },
		{ BabbleBoss["Magmus"], "BRDMagmus" },
		{ BabbleBoss["Emperor Dagran Thaurissan"], "BRDImperatorDagranThaurissan" },
		{ BabbleBoss["Princess Moira Bronzebeard"], "BRDPrincess" },
		{ AtlasLoot_TableNames["BRDBSPlans"][1], "BRDBSPlans" },
		{ AL["Trash Mobs"], "BRDTrash" },
		{ AL["Set: The Gladiator"], "VWOWBlackrockD" },
	},
	["LowerBlackrock"] = {
		{ BabbleBoss["Spirestone Butcher"], "LBRSSpirestoneButcher" },
		{ BabbleBoss["Highlord Omokk"], "LBRSOmokk" },
		{ BabbleBoss["Spirestone Battle Lord"], "LBRSSpirestoneLord" },
		{ BabbleBoss["Spirestone Lord Magus"], "LBRSLordMagus" },
		{ BabbleBoss["Shadow Hunter Vosh'gajin"], "LBRSVosh" },
		{ BabbleBoss["War Master Voone"], "LBRSVoone" },
		{ BabbleBoss["Mor Grayhoof"], "LBRSGrayhoof" },
		{ BabbleBoss["Bannok Grimaxe"], "LBRSGrimaxe" },
		{ BabbleBoss["Mother Smolderweb"], "LBRSSmolderweb" },
		{ BabbleBoss["Crystal Fang"], "LBRSCrystalFang" },
		{ BabbleBoss["Urok Doomhowl"], "LBRSDoomhowl" },
		{ BabbleBoss["Quartermaster Zigris"], "LBRSZigris" },
		{ BabbleBoss["Halycon"], "LBRSHalycon" },
		{ BabbleBoss["Gizrul the Slavener"], "LBRSSlavener" },
		{ BabbleBoss["Ghok Bashguud"], "LBRSBashguud" },
		{ BabbleBoss["Overlord Wyrmthalak"], "LBRSWyrmthalak" },
		{ BabbleBoss["Burning Felguard"], "LBRSFelguard" },
		{ AL["Trash Mobs"], "LBRSTrash" },
		{ AL["Set: Spider's Kiss"], "VWOWSpiderKiss" },
	},
	["UpperBlackrock"] = {
		{ BabbleBoss["Pyroguard Emberseer"], "UBRSEmberseer" },
		{ BabbleBoss["Solakar Flamewreath"], "UBRSSolakar" },
		{ AtlasLoot_TableNames["UBRSFLAME"][1], "UBRSFLAME" },
		{ BabbleBoss["Jed Runewatcher"], "UBRSRunewatcher" },
		{ BabbleBoss["Goraluk Anvilcrack"], "UBRSAnvilcrack" },
		{ BabbleBoss["Warchief Rend Blackhand"], "UBRSRend" },
		{ BabbleBoss["Gyth"], "UBRSGyth" },
		{ BabbleBoss["The Beast"], "UBRSBeast" },
		{ BabbleBoss["Lord Valthalak"], "UBRSValthalak" },
		{ BabbleBoss["General Drakkisath"], "UBRSDrakkisath" },
		{ AL["Trash Mobs"], "UBRSTrash" },
		{ AL["Set: Dal'Rend's Arms"], "VWOWDalRend" },
	},
	["BlackwingLair"] = {
		{ BabbleBoss["Razorgore the Untamed"], "BWLRazorgore" },
		{ BabbleBoss["Vaelastrasz the Corrupt"], "BWLVaelastrasz" },
		{ BabbleBoss["Broodlord Lashlayer"], "BWLLashlayer" },
		{ BabbleBoss["Firemaw"], "BWLFiremaw" },
		{ BabbleBoss["Ebonroc"], "BWLEbonroc" },
		{ BabbleBoss["Flamegor"], "BWLFlamegor" },
		{ BabbleBoss["Chromaggus"], "BWLChromaggus" },
		{ BabbleBoss["Nefarian"], "BWLNefarian" },
		{ AL["Trash Mobs"], "BWLTrashMobs" },
	},
	["Deadmines"] = {
		{ BabbleBoss["Marisa du'Paige"], "TheDeadminesEntrance" },
		{ BabbleBoss["Brainwashed Noble"], "TheDeadminesEntrance" },
		{ BabbleBoss["Foreman Thistlenettle"], "TheDeadminesEntrance" },
		{ BabbleBoss["Rhahk'Zor"], "TheDeadmines1" },
		{ BabbleBoss["Miner Johnson"], "TheDeadmines1" },
		{ BabbleBoss["Sneed"], "TheDeadmines1" },
		{ BabbleBoss["Sneed's Shredder"], "TheDeadmines1" },
		{ BabbleBoss["Gilnid"], "TheDeadmines1" },
		{ BabbleBoss["Captain Greenskin"], "TheDeadmines2" },
		{ BabbleBoss["Edwin VanCleef"], "TheDeadmines2" },
		{ BabbleBoss["Mr. Smite"], "TheDeadmines2" },
		{ BabbleBoss["Cookie"], "TheDeadmines2" },
		{ AL["Set: Defias Leather"], "VWOWDeadmines" },
	},
	["Gnomeregan"] = {
		{ BabbleBoss["Techbot"], "GnTechbot" },
		{ BabbleBoss["Grubbis"], "GnGrubbis" },
		{ BabbleBoss["Viscous Fallout"], "GnViscousFallout" },
		{ BabbleBoss["Electrocutioner 6000"], "GnElectrocutioner6000" },
		{ BabbleBoss["Crowd Pummeler 9-60"], "GnCrowdPummeler960" },
		{ BabbleBoss["Dark Iron Ambassador"], "GnDIAmbassador" },
		{ BabbleBoss["Mekgineer Thermaplugg"], "GnMekgineerThermaplugg" },
		{ AL["Trash Mobs"], "GnTrash" },
	},
	["Karazhan"] = {
		{ AtlasLoot_TableNames["KaraNamed"][1], "KaraNamed" },
		{ BabbleBoss["Attumen the Huntsman"], "KaraAttumen" },
		{ BabbleBoss["Moroes"], "KaraMoroes" },
		{ BabbleBoss["Maiden of Virtue"], "KaraMaiden" },
		{ AtlasLoot_TableNames["KaraOperaEvent"][1], "KaraOperaEvent" },
		{ BabbleBoss["The Curator"], "KaraCurator" },
		{ BabbleBoss["Terestian Illhoof"], "KaraIllhoof" },
		{ BabbleBoss["Shade of Aran"], "KaraAran" },
		{ BabbleBoss["Netherspite"], "KaraNetherspite" },
		{ BabbleBoss["Nightbane"], "KaraNightbane" },
		{ BabbleBoss["Chess Event"], "KaraChess" },
		{ BabbleBoss["Prince Malchezaar"], "KaraPrince" },
		{ AL["Trash Mobs"], "KaraTrash" },
	},
	["MagistersTerrace"] = {
		{ BabbleBoss["Selin Fireheart"], "SMTFireheart" },
		{ BabbleBoss["Vexallus"], "SMTVexallus" },
		{ BabbleBoss["Priestess Delrissa"], "SMTDelrissa" },
		{ BabbleBoss["Kael'thas Sunstrider"], "SMTKaelthas" },
	},
	["MoltenCore"] = {
		{ BabbleBoss["Lucifron"], "MCLucifron" },
		{ BabbleBoss["Magmadar"], "MCMagmadar" },
		{ BabbleBoss["Gehennas"], "MCGehennas" },
		{ BabbleBoss["Garr"], "MCGarr" },
		{ BabbleBoss["Shazzrah"], "MCShazzrah" },
		{ BabbleBoss["Baron Geddon"], "MCGeddon" },
		{ BabbleBoss["Golemagg the Incinerator"], "MCGolemagg" },
		{ BabbleBoss["Sulfuron Harbinger"], "MCSulfuron" },
		{ BabbleBoss["Majordomo Executus"], "MCMajordomo" },
		{ BabbleBoss["Ragnaros"], "MCRagnaros" },
		{ AL["Trash Mobs"], "MCTrashMobs" },
		{ AL["Random Boss Loot"], "MCRANDOMBOSSDROPPS" },
	},
	["Naxxramas"] = {
		{ BabbleBoss["Patchwerk"], "NAXPatchwerk" },
		{ BabbleBoss["Grobbulus"], "NAXGrobbulus" },
		{ BabbleBoss["Gluth"], "NAXGluth" },
		{ BabbleBoss["Thaddius"], "NAXThaddius" },
		{ BabbleBoss["Anub'Rekhan"], "NAXAnubRekhan" },
		{ BabbleBoss["Grand Widow Faerlina"], "NAXGrandWidowFaerlina" },
		{ BabbleBoss["Maexxna"], "NAXMaexxna" },
		{ BabbleBoss["Instructor Razuvious"], "NAXInstructorRazuvious" },
		{ BabbleBoss["Gothik the Harvester"], "NAXGothikderHarvester" },
		{ BabbleBoss["The Four Horsemen"], "NAXTheFourHorsemen" },
		{ BabbleBoss["Noth the Plaguebringer"], "NAXNothderPlaguebringer" },
		{ BabbleBoss["Heigan the Unclean"], "NAXHeiganderUnclean" },
		{ BabbleBoss["Loatheb"], "NAXLoatheb" },
		{ BabbleBoss["Sapphiron"], "NAXSapphiron" },
		{ BabbleBoss["Kel'Thuzad"], "NAXKelThuzard" },
		{ AL["Trash Mobs"], "NAXTrash" },
	},
	["Scarlet Monastery"] = {
		{ BabbleBoss["Interrogator Vishas"], "SMVishas" },
		{ BabbleBoss["Ironspine"], "SMIronspine" },
		{ BabbleBoss["Azshir the Sleepless"], "SMAzshir" },
		{ BabbleBoss["Fallen Champion"], "SMFallenChampion" },
		{ BabbleBoss["Bloodmage Thalnos"], "SMBloodmageThalnos" },
		{ BabbleBoss["Houndmaster Loksey"], "SMHoundmasterLoksey" },
		{ BabbleBoss["Arcanist Doan"], "SMDoan" },
		{ BabbleBoss["Herod"], "SMHerod" },
		{ BabbleBoss["High Inquisitor Fairbanks"], "SMFairbanks" },
		{ BabbleBoss["Scarlet Commander Mograine"], "SMMograine" },
		{ BabbleBoss["High Inquisitor Whitemane"], "SMWhitemane" },
		{ AL["Trash Mobs"], "SMTrash" },
		{ AL["Set: Chain of the Scarlet Crusade"], "VWOWScarletM" },
	},
	["Scholomance"] = {
		{ BabbleBoss["Blood Steward of Kirtonos"], "SCHOLOBloodStewardofKirtonos" },
		{ BabbleBoss["Kirtonos the Herald"], "SCHOLOKirtonostheHerald" },
		{ BabbleBoss["Jandice Barov"], "SCHOLOJandiceBarov" },
		{ BabbleBoss["Rattlegore"], "SCHOLORattlegore" },
		{ BabbleBoss["Death Knight Darkreaver"], "SCHOLODeathKnight" },
		{ BabbleBoss["Marduk Blackpool"], "SCHOLOMarduk" },
		{ BabbleBoss["Vectus"], "SCHOLOVectus" },
		{ BabbleBoss["Ras Frostwhisper"], "SCHOLORasFrostwhisper" },
		{ BabbleBoss["Kormok"], "SCHOLOKormok" },
		{ BabbleBoss["Instructor Malicia"], "SCHOLOInstructorMalicia" },
		{ BabbleBoss["Doctor Theolen Krastinov"], "SCHOLODoctorTheolenKrastinov" },
		{ BabbleBoss["Lorekeeper Polkelt"], "SCHOLOLorekeeperPolkelt" },
		{ BabbleBoss["The Ravenian"], "SCHOLOTheRavenian" },
		{ BabbleBoss["Lord Alexei Barov"], "SCHOLOLordAlexeiBarov" },
		{ BabbleBoss["Lady Illucia Barov"], "SCHOLOLadyIlluciaBarov" },
		{ BabbleBoss["Darkmaster Gandling"], "SCHOLODarkmasterGandling" },
		{ AL["Trash Mobs"], "SCHOLOTrash" },
		{ AL["Set: Necropile Raiment"], "VWOWScholo" },
		{ AL["Set: Cadaverous Garb"], "VWOWScholo" },
		{ AL["Set: Bloodmail Regalia"], "VWOWScholo" },
		{ AL["Set: Deathbone Guardian"], "VWOWScholo" },
	},
	["ShadowfangKeep"] = {
		{ AtlasLoot_TableNames["BSFRethilgore"][1], "BSFRethilgore" },
		{ AtlasLoot_TableNames["BSFFelSteed"][1], "BSFFelSteed" },
		{ BabbleBoss["Razorclaw the Butcher"], "BSFRazorclawtheButcher" },
		{ BabbleBoss["Baron Silverlaine"], "BSFSilverlaine" },
		{ BabbleBoss["Commander Springvale"], "BSFSpringvale" },
		{ BabbleBoss["Odo the Blindwatcher"], "BSFOdotheBlindwatcher" },
		{ BabbleBoss["Deathsworn Captain"], "BSFDeathswornCaptain" },
		{ BabbleBoss["Fenrus the Devourer"], "BSFFenrustheDevourer" },
		{ BabbleBoss["Arugal's Voidwalker"], "BSFArugalsVoidwalker" },
		{ BabbleBoss["Wolf Master Nandos"], "BSFWolfMasterNandos" },
		{ BabbleBoss["Archmage Arugal"], "BSFArchmageArugal" },
		{ AL["Trash Mobs"], "BSFTrash" },
	},
	["Stratholme"] = {
		{ BabbleBoss["Skul"], "STRATSkull" },
		{ AtlasLoot_TableNames["STRATStratholmeCourier"][1], "STRATStratholmeCourier" },
		{ BabbleBoss["Fras Siabi"], "STRATFrasSiabi" },
		{ AtlasLoot_TableNames["STRATAtiesh"][1], "STRATAtiesh" },
		{ BabbleBoss["Hearthsinger Forresten"], "STRATHearthsingerForresten" },
		{ BabbleBoss["The Unforgiven"], "STRATTheUnforgiven" },
		{ BabbleBoss["Timmy the Cruel"], "STRATTimmytheCruel" },
		{ AtlasLoot_TableNames["STRATMalorsStrongbox"][1], "STRATMalorsStrongbox" },
		{ BabbleBoss["Crimson Hammersmith"], "STRATCrimsonHammersmith" },
		{ AtlasLoot_TableNames["STRATBSPlansSerenity"][1], "STRATBSPlansSerenity" },
		{ BabbleBoss["Cannon Master Willey"], "STRATCannonMasterWilley" },
		{ BabbleBoss["Archivist Galford"], "STRATArchivistGalford" },
		{ BabbleBoss["Balnazzar"], "STRATBalnazzar" },
		{ AL["Sothos and Jarien"], "STRATSothosJarien" },
		{ AtlasLoot_TableNames["STRATStonespine"][1], "STRATStonespine" },
		{ BabbleBoss["Baroness Anastari"], "STRATBaronessAnastari" },
		{ BabbleBoss["Black Guard Swordsmith"], "STRATBlackGuardSwordsmith" },
		{ AtlasLoot_TableNames["STRATBSPlansCorruption"][1], "STRATBSPlansCorruption" },
		{ BabbleBoss["Nerub'enkan"], "STRATNerubenkan" },
		{ BabbleBoss["Maleki the Pallid"], "STRATMalekithePallid" },
		{ BabbleBoss["Magistrate Barthilas"], "STRATMagistrateBarthilas" },
		{ BabbleBoss["Ramstein the Gorger"], "STRATRamsteintheGorger" },
		{ BabbleBoss["Baron Rivendare"], "STRATBaronRivendare" },
		{ AL["Trash Mobs"], "STRATTrash" },
		{ AL["Set: The Postmaster"], "VWOWStrat" },
	},
	["SunkenTemple"] = {
		{ AtlasLoot_TableNames["STSpawnOfHakkar"][1], "STSpawnOfHakkar" },
		{ AtlasLoot_TableNames["STTrollMinibosses"][1], "STTrollMinibosses" },
		{ BabbleBoss["Atal'alarion"], "STAtalalarion" },
		{ BabbleBoss["Dreamscythe"], "STDreamscythe" },
		{ BabbleBoss["Weaver"], "STWeaver"},
		{ BabbleBoss["Avatar of Hakkar"], "STAvatarofHakkar" },
		{ BabbleBoss["Jammal'an the Prophet"], "STJammalan" },
		{ BabbleBoss["Ogom the Wretched"], "STOgom" },
		{ BabbleBoss["Morphaz"], "STMorphaz" },
		{ BabbleBoss["Hazzas"], "STHazzas" },
		{ BabbleBoss["Shade of Eranikus"], "STEranikus" },
		{ AL["Trash Mobs"], "STTrash" },
	},
	["Uldaman"] = {
		{ BabbleBoss["Digmaster Shovelphlange"], "UldShovelphlange" },
		{ AtlasLoot_TableNames["UldBaelog"][1], "UldBaelog" },
		{ BabbleBoss["Revelosh"], "UldRevelosh" },
		{ BabbleBoss["Ironaya"], "UldIronaya" },
		{ BabbleBoss["Ancient Stone Keeper"], "UldAncientStoneKeeper" },
		{ BabbleBoss["Galgann Firehammer"], "UldGalgannFirehammer" },
		{ BabbleBoss["Grimlok"], "UldGrimlok" },
		{ BabbleBoss["Archaedas"], "UldArchaedas" },
		{ AL["Trash Mobs"], "UldTrash" },
	},
	["ZulGurub"] = {
		{ BabbleBoss["High Priestess Jeklik"], "ZGJeklik" },
		{ BabbleBoss["High Priest Venoxis"], "ZGVenoxis" },
		{ BabbleBoss["High Priestess Mar'li"], "ZGMarli" },
		{ BabbleBoss["Bloodlord Mandokir"], "ZGMandokir" },
		{ BabbleBoss["Gri'lek"], "ZGGrilek" },
		{ BabbleBoss["Hazza'rah"], "ZGHazzarah" },
		{ BabbleBoss["Renataki"], "ZGRenataki" },
		{ BabbleBoss["Wushoolay"], "ZGWushoolay" },
		{ BabbleBoss["Gahz'ranka"], "ZGGahzranka" },
		{ BabbleBoss["High Priest Thekal"], "ZGThekal" },
		{ BabbleBoss["High Priestess Arlokk"], "ZGArlokk" },
		{ BabbleBoss["Jin'do the Hexxer"], "ZGJindo" },
		{ BabbleBoss["Hakkar"], "ZGHakkar" },
		{ AL["Random Boss Loot"], "ZGShared" },
		{ AL["Trash Mobs"], "ZGTrash1" },
		{ AL["ZG Enchants"], "ZGEnchants" },
	},
	["BlackfathomDeeps"] = {
		{ BabbleBoss["Ghamoo-ra"], "BFDGhamoora" },
		{ AL["Lorgalis Manuscript"], "BFDQuestItems" },
		{ BabbleBoss["Lady Sarevess"], "BFDLadySarevess" },
		{ BabbleBoss["Gelihast"], "BFDGelihast" },
		{ BabbleBoss["Baron Aquanis"], "BFDBaronAquanis" },
		{ AL["Fathom Core"], "BFDQuestItems" },
		{ BabbleBoss["Twilight Lord Kelris"], "BFDTwilightLordKelris" },
		{ BabbleBoss["Old Serra'kis"], "BFDOldSerrakis" },
		{ BabbleBoss["Aku'mai"], "BFDAkumai" },
		{ AL["Trash Mobs"], "BFDTrash" },
	},
	["CoTOldHillsbrad"] = {
		{ BabbleBoss["Lieutenant Drake"], "CoTHillsbradDrake" },
		{ BabbleBoss["Captain Skarloc"], "CoTHillsbradSkarloc" },
		{ BabbleBoss["Epoch Hunter"], "CoTHillsbradHunter" },
		{ AL["Trash Mobs"], "CoTHillsbradTrash" },
		{ AtlasLoot_TableNames["CoTHillsbradThomasYance"][1], "CoTHillsbradThomasYance" },
		{ AtlasLoot_TableNames["CoTHillsbradAgedDalaranWizard"][1], "CoTHillsbradAgedDalaranWizard" },
		{ AtlasLoot_TableNames["CoTHillsbradDonCarlos"][1], "CoTHillsbradDonCarlos" },
	},
	["CoTBlackMorass"] = {
		{ BabbleBoss["Chrono Lord Deja"], "CoTMorassDeja" },
		{ BabbleBoss["Temporus"], "CoTMorassTemporus" },
		{ BabbleBoss["Aeonus"], "CoTMorassAeonus" },
		{ AL["Trash Mobs"], "CoTMorassTrash" },
	},
	["CoTHyjal"] = {
		{ BabbleBoss["Rage Winterchill"], "MountHyjalWinterchill" },
		{ BabbleBoss["Anetheron"], "MountHyjalAnetheron" },
		{ BabbleBoss["Kaz'rogal"], "MountHyjalKazrogal" },
		{ BabbleBoss["Azgalor"], "MountHyjalAzgalor" },
		{ BabbleBoss["Archimonde"], "MountHyjalArchimonde" },
		{ AL["Trash Mobs"], "MountHyjalTrash" },
	},
	["DireMaulEast"] = {
		{ BabbleBoss["Pusillin"], "DMEPusillin" },
		{ BabbleBoss["Zevrim Thornhoof"], "DMEZevrimThornhoof" },
		{ BabbleBoss["Hydrospawn"], "DMEHydro" },
		{ BabbleBoss["Lethtendris"], "DMELethtendris" },
		{ BabbleBoss["Pimgib"], "DMEPimgib" },
		{ BabbleBoss["Alzzin the Wildshaper"], "DMEAlzzin" },
		{ BabbleBoss["Isalien"], "DMEIsalien" },
		{ AL["Trash Mobs"], "DMETrash" },
		{ AL["Dire Maul Books"], "DMBooks" },
	},
	["DireMaulWest"] = {
		{ BabbleBoss["Tendris Warpwood"], "DMWTendrisWarpwood" },
		{ BabbleBoss["Illyanna Ravenoak"], "DMWIllyannaRavenoak" },
		{ BabbleBoss["Magister Kalendris"], "DMWMagisterKalendris" },
		{ BabbleBoss["Tsu'zee"], "DMWTsuzee" },
		{ BabbleBoss["Immol'thar"], "DMWImmolthar" },
		{ BabbleBoss["Lord Hel'nurath"], "DMWHelnurath" },
		{ BabbleBoss["Prince Tortheldrin"], "DMWPrinceTortheldrin" },
		{ AL["Trash Mobs"], "DMWTrash" },
		{ AL["Dire Maul Books"], "DMBooks" }, 
	},
	["DireMaulNorth"] = {
		{ BabbleBoss["Guard Mol'dar"], "DMNGuardMoldar" },
		{ BabbleBoss["Stomper Kreeg"], "DMNStomperKreeg" },
		{ BabbleBoss["Guard Fengus"], "DMNGuardFengus" },
		{ AtlasLoot_TableNames["DMNThimblejack"][1], "DMNThimblejack" },
		{ BabbleBoss["Guard Slip'kik"], "DMNGuardSlipkik" },
		{ BabbleBoss["Captain Kromcrush"], "DMNCaptainKromcrush" },
		{ BabbleBoss["King Gordok"], "DMNKingGordok" },
		{ BabbleBoss["Cho'Rush the Observer"], "DMNChoRush" },
		{ AL["Tribute Run"], "DMNTRIBUTERUN" },
		{ AL["Dire Maul Books"], "DMBooks" },
	},
	["Maraudon"] = {
		{ BabbleBoss["Noxxion"], "MaraNoxxion" },
		{ BabbleBoss["Razorlash"], "MaraRazorlash" },
		{ BabbleBoss["Lord Vyletongue"], "MaraLordVyletongue" },
		{ BabbleBoss["Meshlok the Harvester"], "MaraMeshlok" },
		{ BabbleBoss["Celebras the Cursed"], "MaraCelebras" },
		{ BabbleBoss["Landslide"], "MaraLandslide" },
		{ BabbleBoss["Tinkerer Gizlock"], "MaraTinkererGizlock" },
		{ BabbleBoss["Rotgrip"], "MaraRotgrip" },
		{ BabbleBoss["Princess Theradras"], "MaraPrincessTheradras" },
	},
	["Onyxia"] = {
		 { BabbleBoss["Onyxia"], "Onyxia" },
	},
	["RazorfenDowns"] = {
		{ BabbleBoss["Tuten'kash"], "RFDTutenkash" },
		{ AtlasLoot_TableNames["RFDHenryStern"][1], "RFDHenryStern" },
		{ BabbleBoss["Plaguemaw the Rotting"], "RFDPlaguemaw" },
		{ BabbleBoss["Mordresh Fire Eye"], "RFDMordreshFireEye" },
		{ BabbleBoss["Glutton"], "RFDGlutton" },
		{ BabbleBoss["Ragglesnout"], "RFDRagglesnout" },
		{ BabbleBoss["Amnennar the Coldbringer"], "RFDAmnennar" },
		{ AL["Trash Mobs"], "RFDTrash" },
	},
	["RazorfenKraul"] = {
		{ AtlasLoot_TableNames["RFKThorncurse"][1], "RFKThorncurse" },
		{ BabbleBoss["Death Speaker Jargba"], "RFKDeathSpeakerJargba" },
		{ BabbleBoss["Overlord Ramtusk"], "RFKOverlordRamtusk" },
		{ AtlasLoot_TableNames["RFKRazorfenSpearhide"][1], "RFKRazorfenSpearhide" },
		{ BabbleBoss["Agathelos the Raging"], "RFKAgathelos" },
		{ BabbleBoss["Blind Hunter"], "RFKBlindHunter" },
		{ BabbleBoss["Charlga Razorflank"], "RFKCharlgaRazorflank" },
		{ BabbleBoss["Earthcaller Halmgar"], "RFKEarthcallerHalmgar" },
		{ AL["Trash Mobs"], "RFKTrash" },
	},
	["RuinsofAQ"] = {
		{ BabbleBoss["Kurinnaxx"], "AQ20Kurinnaxx" },
		{ BabbleBoss["Lieutenant General Andorov"], "AQ20Andorov" },
		{ AtlasLoot_TableNames["AQ20CAPTIAN"][1], "AQ20CAPTIAN" },
		{ BabbleBoss["General Rajaxx"], "AQ20Rajaxx" },
		{ BabbleBoss["Moam"], "AQ20Moam" },
		{ BabbleBoss["Buru the Gorger"], "AQ20Buru" },
		{ BabbleBoss["Ayamiss the Hunter"], "AQ20Ayamiss" },
		{ BabbleBoss["Ossirian the Unscarred"], "AQ20Ossirian" },
		{ AL["Trash Mobs"], "AQ20Trash" },
		{ AL["Class Books"], "AQ20ClassBooks" },
		{ AL["AQ Enchants"], "AQEnchants" },
		{ AL["Ruins of Ahn'Qiraj Sets"], "AQ20Sets1" },
	},
	["TempleofAQ"] = {
		{ BabbleBoss["The Prophet Skeram"], "AQ40Skeram" },
		{ BabbleBoss["The Bug Family"], "AQ40Vem" },
		{ BabbleBoss["Battleguard Sartura"], "AQ40Sartura" },
		{ BabbleBoss["Fankriss the Unyielding"], "AQ40Fankriss" },
		{ BabbleBoss["Viscidus"], "AQ40Viscidus" },
		{ BabbleBoss["Princess Huhuran"], "AQ40Huhuran" },
		{ BabbleBoss["The Twin Emperors"], "AQ40Emperors" },
		{ BabbleBoss["Ouro"], "AQ40Ouro" },
		{ BabbleBoss["C'Thun"], "AQ40CThun" },
		{ AL["Trash Mobs"], "AQ40Trash1" },
		{ AL["AQ Enchants"], "AQEnchants" },
		{ AL["AQ Opening Quest Chain"], "AQOpening" },
	},
	["WailingCaverns"] = {
		{ AtlasLoot_TableNames["WCKalldanFelmoon"][1], "WCKalldanFelmoon" },
		{ BabbleBoss["Mad Magglish"], "WCMadMagglish" },
		{ BabbleBoss["Trigore the Lasher"], "WCTrigoretheLasher" },
		{ BabbleBoss["Boahn"], "WCBoahn" },
		{ BabbleBoss["Lord Cobrahn"], "WCLordCobrahn" },
		{ BabbleBoss["Lady Anacondra"], "WCLadyAnacondra" },
		{ BabbleBoss["Kresh"], "WCKresh" },
		{ BabbleBoss["Lord Pythas"], "WCLordPythas" },
		{ BabbleBoss["Skum"], "WCSkum" },
		{ BabbleBoss["Lord Serpentis"], "WCLordSerpentis" },
		{ BabbleBoss["Verdan the Everliving"], "WCVerdan" },
		{ BabbleBoss["Mutanus the Devourer"], "WCMutanus" },
		{ BabbleBoss["Deviate Faerie Dragon"], "WCDeviateFaerieDragon" },
		{ AL["Set: Embrace of the Viper"], "VWOWWailingC" },
	},
	["ZulFarrak"] = {
		{ BabbleBoss["Antu'sul"], "ZFAntusul" },
		{ BabbleBoss["Theka the Martyr"], "ZFThekatheMartyr" },
		{ BabbleBoss["Witch Doctor Zum'rah"], "ZFWitchDoctorZumrah" },
		{ BabbleBoss["Nekrum Gutchewer"], "ZFNekrumGutchewer" },
		{ BabbleBoss["Shadowpriest Sezz'ziz"], "ZFSezzziz" },
		{ BabbleBoss["Dustwraith"], "ZFDustwraith" },
		{ BabbleBoss["Sergeant Bly"], "ZFSergeantBly" },
		{ BabbleBoss["Sandfury Executioner"], "ZFSandfury" },
		{ BabbleBoss["Hydromancer Velratha"], "ZFHydromancerVelratha" },
		{ BabbleBoss["Gahz'rilla"], "ZFGahzrilla" },
		{ BabbleBoss["Chief Ukorz Sandscalp"], "ZFChiefUkorzSandscalp" },
		{ BabbleBoss["Zerillis"], "ZFZerillis" },
		{ AL["Trash Mobs"], "ZFTrash" },
	},
	["AuchManaTombs"] = {
		{ BabbleBoss["Pandemonius"], "AuchManaPandemonius" },
		{ BabbleBoss["Tavarok"], "AuchManaTavarok" },
		{ BabbleBoss["Nexus-Prince Shaffar"], "AuchManaNexusPrince" },
		{ AL["Yor"], "AuchManaYor" },
		{ AL["Trash Mobs"], "AuchManaTrash" },
	},
	["AuchCrypts"] = {
		{ BabbleBoss["Shirrak the Dead Watcher"], "AuchCryptsShirrak" },
		{ BabbleBoss["Exarch Maladaar"], "AuchCryptsExarch" },
		{ AL["Avatar of the Martyred"], "AuchCryptsAvatar" },
		{ AL["Trash Mobs"], "AuchCryptsTrash" }, 
	},
	["AuchSethekk"] = {
		{ BabbleBoss["Darkweaver Syth"], "AuchSethekkDarkweaver" },
		{ BabbleBoss["Talon King Ikiss"], "AuchSethekkTalonKing" },
		{ BabbleBoss["Anzu"], "AuchSethekkRavenGod" },
		{ AL["Trash Mobs"], "AuchSethekkTrash" },
	},
	["AuchShadowLab"] = {
		{ BabbleBoss["Ambassador Hellmaw"], "AuchShadowHellmaw" },
		{ BabbleBoss["Blackheart the Inciter"], "AuchShadowBlackheart" },
		{ BabbleBoss["Grandmaster Vorpil"], "AuchShadowGrandmaster" },
		{ BabbleBoss["Murmur"], "AuchShadowMurmur" },
		{ AtlasLoot_TableNames["AuchShadowFirstFragmentGuardian"][1], "AuchShadowFirstFragmentGuardian" },
		{ AL["Trash Mobs"], "AuchShadowTrash" },
	},
	["BlackTemple"] = {
		{ BabbleBoss["High Warlord Naj'entus"], "BTNajentus" },
		{ BabbleBoss["Supremus"], "BTSupremus" },
		{ BabbleBoss["Teron Gorefiend"], "BTGorefiend" },
		{ BabbleBoss["Gurtogg Bloodboil"], "BTBloodboil" },
		{ BabbleBoss["Shade of Akama"], "BTAkama" },
		{ BabbleBoss["Reliquary of Souls"], "BTEssencofSouls" },
		{ BabbleBoss["Mother Shahraz"], "BTShahraz" },
		{ BabbleBoss["Illidari Council"], "BTCouncil" },
		{ BabbleBoss["Illidan Stormrage"], "BTIllidanStormrage" },
		{ AL["BT Patterns/Plans"], "BTPatterns" },
		{ AL["Trash Mobs"], "BTTrash" },
	},
	["CFRSlavePens"] = {
		{ BabbleBoss["Mennu the Betrayer"], "CFRSlaveMennu" },
		{ BabbleBoss["Rokmar the Crackler"], "CFRSlaveRokmar" },
		{ BabbleBoss["Quagmirran"], "CFRSlaveQuagmirran" },
	},
	["CFRUnderbog"] = {
		{ BabbleBoss["Hungarfen"], "CFRUnderHungarfen" },
		{ BabbleBoss["Ghaz'an"], "CFRUnderGhazan" },
		{ BabbleBoss["Swamplord Musel'ek"], "CFRUnderSwamplord" },
		{ BabbleBoss["The Black Stalker"], "CFRUnderStalker" },
	},
	["CFRSteamvault"] = {
		{ BabbleBoss["Hydromancer Thespia"], "CFRSteamThespia" },
		{ AtlasLoot_TableNames["CFRSteamSecondFragmentGuardian"][1], "CFRSteamSecondFragmentGuardian" },
		{ BabbleBoss["Mekgineer Steamrigger"], "CFRSteamSteamrigger" },
		{ BabbleBoss["Warlord Kalithresh"], "CFRSteamWarlord" },
		{ AL["Trash Mobs"], "CFRSteamTrash" },
	},
	["CFRSerpentshrine"] = {
		{ BabbleBoss["Hydross the Unstable"], "CFRSerpentHydross" },
		{ BabbleBoss["The Lurker Below"], "CFRSerpentLurker" },
		{ BabbleBoss["Leotheras the Blind"], "CFRSerpentLeotheras" },
		{ BabbleBoss["Fathom-Lord Karathress"], "CFRSerpentKarathress" },
		{ BabbleBoss["Morogrim Tidewalker"], "CFRSerpentMorogrim" },
		{ BabbleBoss["Lady Vashj"], "CFRSerpentVashj" },
		{ AL["Trash Mobs"], "CFRSerpentTrash" },
	},
	["Gruul"] = {
		{ BabbleBoss["High King Maulgar"], "GruulsLairHighKingMaulgar" },
		{ BabbleBoss["Gruul the Dragonkiller"], "GruulGruul" },
	},
	["HCRamparts"] = {
		{ BabbleBoss["Watchkeeper Gargolmar"], "HCRampWatchkeeper" },
		{ BabbleBoss["Omor the Unscarred"], "HCRampOmor" },
		{ BabbleBoss["Vazruden the Herald"], "HCRampVazruden" },
		{ BabbleBoss["Nazan"], "HCRampNazan" },
		{ AtlasLoot_TableNames["HCRampFelIronChest"][1], "HCRampFelIronChest" },
	},
	["HCFurnace"] = {
		{ BabbleBoss["The Maker"], "HCFurnaceMaker" },
		{ BabbleBoss["Broggok"], "HCFurnaceBroggok" },
		{ BabbleBoss["Keli'dan the Breaker"], "HCFurnaceBreaker" },
	},
	["HCShatteredHalls"] = {
		{ BabbleBoss["Grand Warlock Nethekurse"], "HCHallsNethekurse" },
		{ BabbleBoss["Blood Guard Porung"], "HCHallsPorung" },
		{ BabbleBoss["Warbringer O'mrogg"], "HCHallsOmrogg" },
		{ BabbleBoss["Warchief Kargath Bladefist"], "HCHallsKargath" },
		{ AL["Trash Mobs"], "HCHallsTrash" },
	},
	["HCMagLair"] = {
		{ BabbleBoss["Magtheridon"], "HCMagtheridon" },
	},
	["TKMech"] = {
		{ BabbleBoss["Gatewatcher Gyro-Kill"], "TKMechGyro" },
		{ BabbleBoss["Gatewatcher Iron-Hand"], "TKMechIron" },
		{ AtlasLoot_TableNames["TKMechCacheoftheLegion"][1], "TKMechCacheoftheLegion" },
		{ BabbleBoss["Mechano-Lord Capacitus"], "TKMechCapacitus" },
		{ BabbleBoss["Nethermancer Sepethrea"], "TKMechSepethrea" },
		{ BabbleBoss["Pathaleon the Calculator"], "TKMechCalc" },
		{ AL["Trash Mobs"], "TKMechTrash" },
	},
	["TKBot"] = {
		{ BabbleBoss["Commander Sarannis"], "TKBotSarannis" },
		{ BabbleBoss["High Botanist Freywinn"], "TKBotFreywinn" },
		{ BabbleBoss["Thorngrin the Tender"], "TKBotThorngrin" },
		{ BabbleBoss["Laj"], "TKBotLaj" },
		{ BabbleBoss["Warp Splinter"], "TKBotSplinter" },
		{ AL["Trash Mobs"], "TKBotTrash" },
	},
	["TKArc"] = {
		{ BabbleBoss["Zereketh the Unbound"], "TKArcUnbound" },
		{ AtlasLoot_TableNames["TKArcThirdFragmentGuardian"][1], "TKArcThirdFragmentGuardian" },
		{ BabbleBoss["Wrath-Scryer Soccothrates"], "TKArcScryer" },
		{ BabbleBoss["Dalliah the Doomsayer"], "TKArcDalliah" },
		{ BabbleBoss["Harbinger Skyriss"], "TKArcHarbinger" },
		{ AL["Trash Mobs"], "TKArcTrash" },
	},
	["TKEye"] = {
		{ BabbleBoss["Al'ar"], "TKEyeAlar" },
		{ BabbleBoss["High Astromancer Solarian"], "TKEyeSolarian" },
		{ BabbleBoss["Void Reaver"], "TKEyeVoidReaver" },
		{ BabbleBoss["Kael'thas Sunstrider"], "TKEyeKaelthas" },
		{ AL["Legendary Items for Kael'thas Fight"], "TKEyeLegendaries" },
		{ AL["Trash Mobs"], "TKEyeTrash" },
	},
	["ZulAman"] = {
		{ BabbleBoss["Nalorakk"], "ZANalorakk" },
		{ BabbleBoss["Akil'zon"], "ZAAkilZon" },
		{ BabbleBoss["Jan'alai"], "ZAJanAlai" },
		{ BabbleBoss["Halazzi"], "ZAHalazzi" },
		{ BabbleBoss["Hex Lord Malacrass"], "ZAMalacrass" },
		{ BabbleBoss["Zul'jin"], "ZAZuljin" },
		{ AL["Timed Reward Chest"], "ZATimedChest" },
		{ AL["Trash Mobs"], "ZATrash" },
	},
	["SunwellPlateau"] = {
		{ BabbleBoss["Kalecgos"], "SPKalecgos" },
		{ BabbleBoss["Brutallus"], "SPBrutallus" },
		{ BabbleBoss["Felmyst"], "SPFelmyst" },
		{ BabbleBoss["The Eredar Twins"], "SPEredarTwins" },
		{ BabbleBoss["M'uru"], "SPMuru" },
		{ BabbleBoss["Kil'jaeden"], "SPKiljaeden" },
		{ AL["SP Patterns/Plans"], "SPPatterns" },
		{ AL["Trash Mobs"], "SPTrash" },
	},
	["WorldBosses"] = {
		{ BabbleBoss["Azuregos"], "AAzuregos" },
		{ BabbleBoss["Doom Lord Kazzak"], "DoomLordKazzak"},
		{ BabbleBoss["Doomwalker"], "DDoomwalker" },
		{ BabbleBoss["Emeriss"], "DEmeriss" },
		{ AL["Highlord Kruul"], "KKruul" },
		{ BabbleBoss["Lethon"], "DLethon"},
		{ BabbleBoss["Taerar"], "DTaerar" },
		{ BabbleBoss["Ysondre"], "DYsondre" },
	},
	["AbyssalCouncil"] = {
		{ AL["Abyssal Council"].." - "..AL["Templars"], "Templars" },
		{ AL["Abyssal Council"].." - "..AL["Dukes"], "Dukes" },
		{ AL["Abyssal Council"].." - "..AL["High Council"], "HighCouncil" },
	},
	["EthereumPrison"] = {
		{ AL["Armbreaker Huffaz"], "ArmbreakerHuffaz" },
		{ AL["Fel Tinkerer Zortan"], "FelTinkererZortan" },
		{ AL["Forgosh"], "Forgosh" },
		{ AL["Gul'bor"], "Gulbor" },
		{ AL["Malevus the Mad"], "MalevustheMad" },
		{ AL["Porfus the Gem Gorger"], "PorfustheGemGorger" },
		{ AL["Wrathbringer Laz-tarash"], "WrathbringerLaztarash" },
		{ AL["Bash'ir Landing Stasis Chambers"], "BashirStasisChambers" },
	},
	["Skettis"] = {
		{ AL["Darkscreecher Akkarai"], "DarkscreecherAkkarai" },
		{ AL["Gezzarak the Huntress"], "GezzaraktheHuntress" },
		{ AL["Karrog"], "Karrog" },
		{ AL["Terokk"], "Terokk" },
		{ AL["Vakkiz the Windrager"], "VakkiztheWindrager" },
	},
	["Factions"] = {
		{ BabbleFaction["The Aldor"], "Aldor1" },
		{ BabbleFaction["Argent Dawn"], "Argent1" },
		{ BabbleFaction["Ashtongue Deathsworn"], "Ashtongue1" },
		{ BabbleFaction["Bloodsail Buccaneers"], "Bloodsail1" },
		{ BabbleFaction["Brood of Nozdormu"], "AQBroodRings" },
		{ BabbleFaction["Cenarion Circle"], "Cenarion1" },
		{ BabbleFaction["Cenarion Expedition"], "CExpedition1" },
		{ BabbleFaction["The Consortium"], "Consortium1" },
		{ BabbleFaction["Darkmoon Faire"], "Darkmoon1" },
		{ BabbleFaction["Frostwolf Clan"], "Frostwolf1" },
		{ BabbleFaction["Gelkis Clan Centaur"], "GelkisClan1" },
		{ BabbleFaction["Hydraxian Waterlords"], "WaterLords1" },
		{ BabbleFaction["Honor Hold"], "HonorHold1" },
		{ BabbleFaction["Keepers of Time"], "KeepersofTime1" },
		{ BabbleFaction["Kurenai"], "Kurenai1" },
		{ BabbleFaction["Lower City"], "LowerCity1" },
		{ BabbleFaction["The Mag'har"], "Maghar1" },
		{ BabbleFaction["Magram Clan Centaur"], "MagramClan1" },
		{ BabbleFaction["Netherwing"], "Netherwing1" },
		{ BabbleFaction["Ogri'la"], "Ogrila1" },
		{ BabbleFaction["The Scale of the Sands"], "ScaleSands1" },
		{ BabbleFaction["The Scryers"], "Scryer1" },
		{ BabbleFaction["The Sha'tar"], "Shatar1" },
		{ BabbleFaction["Sha'tari Skyguard"], "Skyguard1" },
		{ BabbleFaction["Shattered Sun Offensive"], "SunOffensive1" },
		{ BabbleFaction["Sporeggar"], "Sporeggar1" },
		{ BabbleFaction["Stormpike Guard"], "Stormpike1" },
		{ BabbleFaction["Thorium Brotherhood"], "Thorium1" },
		{ BabbleFaction["Thrallmar"], "Thrallmar1" },
		{ BabbleFaction["Timbermaw Hold"], "Timbermaw" },
		{ BabbleFaction["Tranquillien"], "Tranquillien1" },
		{ BabbleFaction["The Violet Eye"], "VioletEye1" },
		{ BabbleFaction["Wintersaber Trainers"], "Wintersaber1" },
		{ BabbleFaction["Zandalar Tribe"], "Zandalar1" },
	},
	["BoEWorldEpics"] = {
		{ AtlasLoot_TableNames["WorldEpics4"][1], "WorldEpics4" },
		{ AtlasLoot_TableNames["WorldEpics3"][1], "WorldEpics3" },
		{ AtlasLoot_TableNames["WorldEpics2"][1], "WorldEpics2" },
		{ AtlasLoot_TableNames["WorldEpics1"][1], "WorldEpics1" },
	},
	["CraftSetBlacksmith"] = {
		{ AL["Imperial Plate"], "ImperialPlate" },
		{ AL["The Darksoul"], "TheDarksoul" },
		{ AL["Fel Iron Plate"], "FelIronPlate" },
		{ AL["Adamantite Battlegear"], "AdamantiteB" },
		{ AL["Flame Guard"], "FlameG" },
		{ AL["Enchanted Adamantite Armor"], "EnchantedAdaman" },
		{ AL["Khorium Ward"], "KhoriumWard" },
		{ AL["Faith in Felsteel"], "FaithFelsteel" },
		{ AL["Burning Rage"], "BurningRage" },
		{ AL["Bloodsoul Embrace"], "BloodsoulEmbrace" },
		{ AL["Fel Iron Chain"], "FelIronChain" },
	},
	["CraftSetLeatherwork"] = {
		{ AL["Volcanic Armor"], "VolcanicArmor" },
		{ AL["Ironfeather Armor"], "IronfeatherArmor" },
		{ AL["Stormshroud Armor"], "StormshroudArmor" },
		{ AL["Devilsaur Armor"], "DevilsaurArmor" },
		{ AL["Blood Tiger Harness"], "BloodTigerH" },
		{ AL["Primal Batskin"], "PrimalBatskin" },
		{ AL["Wild Draenish Armor"], "WildDraenishA" },
		{ AL["Thick Draenic Armor"], "ThickDraenicA" },
		{ AL["Fel Skin"], "FelSkin" },
		{ AL["Strength of the Clefthoof"], "SClefthoof" },
		{ AL["Primal Intent"], "PrimalIntent" },
		{ AL["Windhawk Armor"], "WindhawkArmor" },   
		{ AL["Green Dragon Mail"], "GreenDragonM" },
		{ AL["Blue Dragon Mail"], "BlueDragonM" },
		{ AL["Black Dragon Mail"], "BlackDragonM" },
		{ AL["Scaled Draenic Armor"], "ScaledDraenicA" },
		{ AL["Felscale Armor"], "FelscaleArmor" },
		{ AL["Felstalker Armor"], "FelstalkerArmor" },
		{ AL["Fury of the Nether"], "NetherFury" },
		{ AL["Netherscale Armor"], "NetherscaleArmor" },
		{ AL["Netherstrike Armor"], "NetherstrikeArmor" },
	},
	["CraftSetTailor"] = {
		{ AL["Bloodvine Garb"], "BloodvineG" },
		{ AL["Netherweave Vestments"], "NeatherVest" },
		{ AL["Imbued Netherweave"], "ImbuedNeather" },
		{ AL["Arcanoweave Vestments"], "ArcanoVest" },
		{ AL["The Unyielding"], "TheUnyielding" },
		{ AL["Whitemend Wisdom"], "WhitemendWis" },
		{ AL["Spellstrike Infusion"], "SpellstrikeInfu" },
		{ AL["Battlecast Garb"], "BattlecastG" },
		{ AL["Soulcloth Embrace"], "SoulclothEm" },
		{ AL["Primal Mooncloth"], "PrimalMoon" },
		{ AL["Shadow's Embrace"], "ShadowEmbrace" },
		{ AL["Wrath of Spellfire"], "SpellfireWrath" },
	},
	["DungeonSets12"] = {
		{ BabbleClass["Druid"], "T0Druid" },
		{ BabbleClass["Hunter"], "T0Hunter" },
		{ BabbleClass["Mage"], "T0Mage" },
		{ BabbleClass["Paladin"], "T0Paladin" },
		{ BabbleClass["Priest"], "T0Priest" },
		{ BabbleClass["Rogue"], "T0Rogue" },
		{ BabbleClass["Shaman"], "T0Shaman" },
		{ BabbleClass["Warlock"], "T0Warlock" },
		{ BabbleClass["Warrior"], "T0Warrior" },
	},
	["DungeonSets3"] = {
		{ AL["Hallowed Raiment"], "DS3Cloth" },
		{ AL["Incanter's Regalia"], "DS3Cloth" },
		{ AL["Mana-Etched Regalia"], "DS3Cloth" },
		{ AL["Oblivion Raiment"], "DS3Cloth" },
		{ AL["Assassination Armor"], "DS3Leather" },
		{ AL["Moonglade Raiment"], "DS3Leather" },
		{ AL["Wastewalker Armor"], "DS3Leather" },
		{ AL["Beast Lord Armor"], "DS3Mail" },
		{ AL["Desolation Battlegear"], "DS3Mail" },
		{ AL["Tidefury Raiment"], "DS3Mail" },
		{ AL["Bold Armor"], "DS3Plate" },
		{ AL["Doomplate Battlegear"], "DS3Plate" },
		{ AL["Righteous Armor"], "DS3Plate" },
	},
	["Lvl70TokenRewards"] = {
        { AtlasLoot_TableNames["HardModeArena"][1], "HardModeArena" },
		{ AtlasLoot_TableNames["HardModeCloth"][1], "HardModeCloth" },
		{ AtlasLoot_TableNames["HardModeLeather"][1], "HardModeLeather" },
		{ AtlasLoot_TableNames["HardModeMail"][1], "HardModeMail" },
		{ AtlasLoot_TableNames["HardModePlate"][1], "HardModePlate" },
		{ AtlasLoot_TableNames["HardModeCloaks"][1], "HardModeCloaks" },
		{ AtlasLoot_TableNames["HardModeResist"][1], "HardModeResist" },
		{ AtlasLoot_TableNames["HardModeAccessories"][1], "HardModeAccessories" },
		{ AtlasLoot_TableNames["HardModeRelic"][1], "HardModeRelic" },
		{ AtlasLoot_TableNames["HardModeWeapons"][1], "HardModeWeapons" },
	},
	["Pre60Sets"] = {
		{ AL["Bloodmail Regalia"], "VWOWScholo" },
		{ AL["Cadaverous Garb"], "VWOWScholo" },
		{ AL["Chain of the Scarlet Crusade"], "VWOWScarletM" },
		{ AL["Dal'Rend's Arms"], "VWOWDalRend" },
		{ AL["Deathbone Guardian"], "VWOWScholo" },
		{ AL["Defias Leather"], "VWOWDeadmines" },
		{ AL["Embrace of the Viper"], "VWOWWailingC" },
		{ AL["Ironweave Battlesuit"], "VWOWIronweave" },
		{ AL["Necropile Raiment"], "VWOWScholo" },
		{ AL["Primal Blessing"], "VWOWZulGurub" },
		{ AL["Scourge Invasion"], "VWOWScourgeInvasion" },
		{ AL["Shard of the Gods"], "VWOWShardOfGods" },
		{ AL["Spider's Kiss"], "VWOWSpiderKiss" },
		{ AL["Spirit of Eskhandar"], "VWOWSpiritofEskhandar" },
		{ AL["The Gladiator"], "VWOWBlackrockD" },
		{ AL["The Postmaster"], "VWOWStrat" },
		{ AL["The Twin Blades of Hakkari"], "VWOWZulGurub" },
		{ AL["Zul'Gurub Rings"], "VWOWZulGurub" },
		{ AL["Latro's Flurry"], "TBCSets" },
		{ AL["The Twin Stars"], "TBCSets" },
		{ AL["The Twin Blades of Azzinoth"], "TBCSets" },
	},
	["T1T2Sets"] = {
		{ BabbleClass["Druid"], "T1T2Druid" },
		{ BabbleClass["Hunter"], "T1T2Hunter" },
		{ BabbleClass["Mage"], "T1T2Mage" },
		{ BabbleClass["Paladin"], "T1T2Paladin" },
		{ BabbleClass["Priest"], "T1T2Priest" },
		{ BabbleClass["Rogue"], "T1T2Rogue" },
		{ BabbleClass["Shaman"], "T1T2Shaman" },
		{ BabbleClass["Warlock"], "T1T2Warlock" },
		{ BabbleClass["Warrior"], "T1T2Warrior" },
	},
	["T3Sets"] = {
		{ BabbleClass["Druid"], "T3Druid" },
		{ BabbleClass["Hunter"], "T3Hunter" },
		{ BabbleClass["Mage"], "T3Mage" },
		{ BabbleClass["Paladin"], "T3Paladin" },
		{ BabbleClass["Priest"], "T3Priest" },
		{ BabbleClass["Rogue"], "T3Rogue" },
		{ BabbleClass["Shaman"], "T3Shaman" },
		{ BabbleClass["Warlock"], "T3Warlock" },
		{ BabbleClass["Warrior"], "T3Warrior" },
	},
	["T4Sets"] = {
		{ BabbleClass["Druid"], "T4Druid" },
		{ BabbleClass["Hunter"], "T4Hunter" },
		{ BabbleClass["Mage"], "T4Mage" },
		{ BabbleClass["Paladin"], "T4Paladin" },
		{ BabbleClass["Priest"], "T4Priest" },
		{ BabbleClass["Rogue"], "T4Rogue" },
		{ BabbleClass["Shaman"], "T4Shaman" },
		{ BabbleClass["Warlock"], "T4Warlock" },
		{ BabbleClass["Warrior"], "T4Warrior" },
	},
	["T5Sets"] = {
		{ BabbleClass["Druid"], "T5Druid" },
		{ BabbleClass["Hunter"], "T5Hunter" },
		{ BabbleClass["Mage"], "T5Mage" },
		{ BabbleClass["Paladin"], "T5Paladin" },
		{ BabbleClass["Priest"], "T5Priest" },
		{ BabbleClass["Rogue"], "T5Rogue" },
		{ BabbleClass["Shaman"], "T5Shaman" },
		{ BabbleClass["Warlock"], "T5Warlock" },
		{ BabbleClass["Warrior"], "T5Warrior" },
	},
	["T6Sets"] = {
		{ BabbleClass["Druid"], "T6Druid" },
		{ BabbleClass["Hunter"], "T6Hunter" },
		{ BabbleClass["Mage"], "T6Mage" },
		{ BabbleClass["Paladin"], "T6Paladin" },
		{ BabbleClass["Priest"], "T6Priest" },
		{ BabbleClass["Rogue"], "T6Rogue" },
		{ BabbleClass["Shaman"], "T6Shaman" },
		{ BabbleClass["Warlock"], "T6Warlock" },
		{ BabbleClass["Warrior"], "T6Warrior" },
	},
	["ZGSets"] = {
		{ BabbleClass["Druid"], "ZGDruid" },
		{ BabbleClass["Hunter"], "ZGHunter" },
		{ BabbleClass["Mage"], "ZGMage" },
		{ BabbleClass["Paladin"], "ZGPaladin" },
		{ BabbleClass["Priest"], "ZGPriest" },
		{ BabbleClass["Rogue"], "ZGRogue" },
		{ BabbleClass["Shaman"], "ZGShaman" },
		{ BabbleClass["Warlock"], "ZGWarlock" },
		{ BabbleClass["Warrior"], "ZGWarrior" },
	},
	["ArenaPvPRewards"] = {
		{ BabbleClass["Druid"], "ArenaDruid" },
		{ BabbleClass["Hunter"], "ArenaHunter" },
		{ BabbleClass["Mage"], "ArenaMage" },
		{ BabbleClass["Paladin"], "ArenaPaladin" },
		{ BabbleClass["Priest"], "ArenaPriest" },
		{ BabbleClass["Rogue"], "ArenaRogue" },
		{ BabbleClass["Shaman"], "ArenaShaman" },
		{ BabbleClass["Warlock"], "ArenaWarlock" },
		{ BabbleClass["Warrior"], "ArenaWarrior" },
	},
	["Arena2PvPRewards"] = {
		{ BabbleClass["Druid"], "Arena2Druid" },
		{ BabbleClass["Hunter"], "Arena2Hunter" },
		{ BabbleClass["Mage"], "Arena2Mage" },
		{ BabbleClass["Paladin"], "Arena2Paladin" },
		{ BabbleClass["Priest"], "Arena2Priest" },
		{ BabbleClass["Rogue"], "Arena2Rogue" },
		{ BabbleClass["Shaman"], "Arena2Shaman" },
		{ BabbleClass["Warlock"], "Arena2Warlock" },
		{ BabbleClass["Warrior"], "Arena2Warrior" },
		{ AL["Arena 2 PvP Weapons"], "Arena2Weapons1" },
	},
	["Arena3PvPRewards"] = {
		{ BabbleClass["Druid"], "Arena3Druid" },
		{ BabbleClass["Hunter"], "Arena3Hunter" },
		{ BabbleClass["Mage"], "Arena3Mage" },
		{ BabbleClass["Paladin"], "Arena3Paladin" },
		{ BabbleClass["Priest"], "Arena3Priest" },
		{ BabbleClass["Rogue"], "Arena3Rogue" },
		{ BabbleClass["Shaman"], "Arena3Shaman" },
		{ BabbleClass["Warlock"], "Arena3Warlock" },
		{ BabbleClass["Warrior"], "Arena3Warrior" },
		{ AL["Arena 3 PvP Weapons"], "Arena3Weapons1" },
	},
	["Arena4PvPRewards"] = {
		{ BabbleClass["Druid"], "Arena4Druid" },
		{ BabbleClass["Hunter"], "Arena4Hunter" },
		{ BabbleClass["Mage"], "Arena4Mage" },
		{ BabbleClass["Paladin"], "Arena4Paladin" },
		{ BabbleClass["Priest"], "Arena4Priest" },
		{ BabbleClass["Rogue"], "Arena4Rogue" },
		{ BabbleClass["Shaman"], "Arena4Shaman" },
		{ BabbleClass["Warlock"], "Arena4Warlock" },
		{ BabbleClass["Warrior"], "Arena4Warrior" },
		{ AL["Arena 4 PvP Weapons"], "Arena4Weapons1" },
	},
	["AVRewards"] = {
		{ AL["Misc. Rewards"], "AVMisc" },
		{ AL["Superior Rewards"], "AVBlue" },
		{ AL["Epic Rewards"], "AVPurple" },
	},
	["ABRewards"] = {
		{ AL["Misc. Rewards"], "ABMisc" },
		{ AtlasLoot_TableNames["AB20291"][1], "AB20291" },
		{ AtlasLoot_TableNames["AB3039"][1], "AB3039" },
		{ AtlasLoot_TableNames["AB40491"][1], "AB40491" },
		{ AtlasLoot_TableNames["AB5059"][1], "AB5059" },
		{ AtlasLoot_TableNames["AB60"][1], "AB60" },
	},
	["ABSets"] = {
		{ AtlasLoot_TableNames["ABSets1"][1], "ABSets1" },
		{ AtlasLoot_TableNames["ABSets2"][1], "ABSets2" },
		{ AtlasLoot_TableNames["ABSets3"][1], "ABSets3" },
	},
	["PvPNonSetEpic"] = {
		{ AtlasLoot_TableNames["PvP70NonSet1"][1], "PvP70NonSet1" },
		{ AtlasLoot_TableNames["PvP70NonSet2"][1], "PvP70NonSet2" },
		{ AtlasLoot_TableNames["PvP70NonSet3"][1], "PvP70NonSet3" },
		{ AtlasLoot_TableNames["PvP70NonSet4"][1], "PvP70NonSet4" },
		{ AtlasLoot_TableNames["PvP70NonSet5"][1], "PvP70NonSet5" },
	},
	["PvPLvl60Rewards"] = {
		{ BabbleClass["Druid"], "PVPDruid" },
		{ BabbleClass["Hunter"], "PVPHunter" },
		{ BabbleClass["Mage"], "PVPMage" },
		{ BabbleClass["Paladin"], "PVPPaladin" },
		{ BabbleClass["Priest"], "PVPPriest" },
		{ BabbleClass["Rogue"], "PVPRogue" },
		{ BabbleClass["Shaman"], "PVPShaman" },
		{ BabbleClass["Warlock"], "PVPWarlock" },
		{ BabbleClass["Warrior"], "PVPWarrior" },
		{ AtlasLoot_TableNames["PVPWeapons1"][1], "PVPWeapons1" },
		{ AtlasLoot_TableNames["PvP60Accessories1"][1], "PvP60Accessories1" },
	},
	["PvPLvl70Rewards"] = {
		{ BabbleClass["Druid"], "PVP70RepDruid" },
		{ BabbleClass["Hunter"], "PVP70RepHunter" },
		{ BabbleClass["Mage"], "PVP70RepMage" },
		{ BabbleClass["Paladin"], "PVP70RepPaladin" },
		{ BabbleClass["Priest"], "PVP70RepPriest" },
		{ BabbleClass["Rogue"], "PVP70RepRogue" },
		{ BabbleClass["Shaman"], "PVP70RepShaman" },
		{ BabbleClass["Warlock"], "PVP70RepWarlock" },
		{ BabbleClass["Warrior"], "PVP70RepWarrior" },
		{ AtlasLoot_TableNames["PvP70Accessories1"][1], "PvP70Accessories1" },
	},
	["WSGRewards"] = {
		{ AL["Misc. Rewards"], "WSGMisc" },
		{ AtlasLoot_TableNames["WSG1019"][1], "WSG1019" },
		{ AtlasLoot_TableNames["WSG2029"][1], "WSG2029" },
		{ AtlasLoot_TableNames["WSG3039"][1], "WSG3039" },
		{ AtlasLoot_TableNames["WSG4049"][1], "WSG4049" },
		{ AtlasLoot_TableNames["WSG5059"][1], "WSG5059" },
		{ AtlasLoot_TableNames["WSG60"][1], "WSG60" },
	},
	["Alchemy"] = {
		{ AtlasLoot_TableNames["AlchemyApprentice1"][1], "AlchemyApprentice1" },
		{ AtlasLoot_TableNames["AlchemyJourneyman1"][1], "AlchemyJourneyman1" },
		{ AtlasLoot_TableNames["AlchemyExpert1"][1], "AlchemyExpert1" },
		{ AtlasLoot_TableNames["AlchemyArtisan1"][1], "AlchemyArtisan1" },
		{ AtlasLoot_TableNames["AlchemyMaster1"][1], "AlchemyMaster1" },
	},
	["BlackSmithing"] = {
		{ AtlasLoot_TableNames["SmithingApprentice1"][1], "SmithingApprentice1" },
		{ AtlasLoot_TableNames["SmithingJourneyman1"][1], "SmithingJourneyman1" },
		{ AtlasLoot_TableNames["SmithingExpert1"][1], "SmithingExpert1" },
		{ AtlasLoot_TableNames["SmithingArtisan1"][1], "SmithingArtisan1" },
		{ AtlasLoot_TableNames["SmithingMaster1"][1], "SmithingMaster1" },
		{ AtlasLoot_TableNames["Armorsmith1"][1], "Armorsmith1" },
		{ AtlasLoot_TableNames["Weaponsmith1"][1], "Weaponsmith1" },
		{ AtlasLoot_TableNames["Axesmith1"][1], "Axesmith1" },
		{ AtlasLoot_TableNames["Hammersmith1"][1], "Hammersmith1" },
		{ AtlasLoot_TableNames["Swordsmith1"][1], "Swordsmith1" },
	},
	["Cooking"] = {
		{ AtlasLoot_TableNames["CookingApprentice1"][1], "CookingApprentice1" },
		{ AtlasLoot_TableNames["CookingJourneyman1"][1], "CookingJourneyman1" },
		{ AtlasLoot_TableNames["CookingExpert1"][1], "CookingExpert1" },
		{ AtlasLoot_TableNames["CookingArtisan1"][1], "CookingArtisan1" },
		{ AtlasLoot_TableNames["CookingMaster1"][1], "CookingMaster1" },
	},
	["Enchanting"] = {
		{ AtlasLoot_TableNames["EnchantingApprentice1"][1], "EnchantingApprentice1" },
		{ AtlasLoot_TableNames["EnchantingJourneyman1"][1], "EnchantingJourneyman1" },
		{ AtlasLoot_TableNames["EnchantingExpert1"][1], "EnchantingExpert1" },
		{ AtlasLoot_TableNames["EnchantingArtisan1"][1], "EnchantingArtisan1" },
		{ AtlasLoot_TableNames["EnchantingMaster1"][1], "EnchantingMaster1" },
	},
	["Engineering"] = {
		{ AtlasLoot_TableNames["EngineeringApprentice1"][1], "EngineeringApprentice1" },
		{ AtlasLoot_TableNames["EngineeringJourneyman1"][1], "EngineeringJourneyman1" },
		{ AtlasLoot_TableNames["EngineeringExpert1"][1], "EngineeringExpert1" },
		{ AtlasLoot_TableNames["EngineeringArtisan1"][1], "EngineeringArtisan1" },
		{ AtlasLoot_TableNames["EngineeringMaster1"][1], "EngineeringMaster1" },
		{ AtlasLoot_TableNames["Gnomish1"][1], "Gnomish1" },
		{ AtlasLoot_TableNames["Goblin1"][1], "Goblin1" },
	},
	["Jewelcrafting"] = {
		{ AtlasLoot_TableNames["JewelApprentice1"][1], "JewelApprentice1" },
		{ AtlasLoot_TableNames["JewelJourneyman1"][1], "JewelJourneyman1" },
		{ AtlasLoot_TableNames["JewelExpert1"][1], "JewelExpert1" },
		{ AtlasLoot_TableNames["JewelArtisan1"][1], "JewelArtisan1" },
		{ AtlasLoot_TableNames["JewelMaster1"][1], "JewelMaster1" },
	},
	["Leatherworking"] = {
		{ AtlasLoot_TableNames["LeatherApprentice1"][1], "LeatherApprentice1" },
		{ AtlasLoot_TableNames["LeatherJourneyman1"][1], "LeatherJourneyman1" },
		{ AtlasLoot_TableNames["LeatherExpert1"][1], "LeatherExpert1" },
		{ AtlasLoot_TableNames["LeatherArtisan1"][1], "LeatherArtisan1" },
		{ AtlasLoot_TableNames["LeatherMaster1"][1], "LeatherMaster1" },
		{ AtlasLoot_TableNames["Dragonscale1"][1], "Dragonscale1" },
		{ AtlasLoot_TableNames["Elemental1"][1], "Elemental1" },
		{ AtlasLoot_TableNames["Tribal1"][1], "Tribal1" },
	},
	["Tailoring"] = {
		{ AtlasLoot_TableNames["TailoringApprentice1"][1], "TailoringApprentice1" },
		{ AtlasLoot_TableNames["TailoringJourneyman1"][1], "TailoringJourneyman1" },
		{ AtlasLoot_TableNames["TailoringExpert1"][1], "TailoringExpert1" },
		{ AtlasLoot_TableNames["TailoringArtisan1"][1], "TailoringArtisan1" },
		{ AtlasLoot_TableNames["TailoringMaster1"][1], "TailoringMaster1" },
		{ AtlasLoot_TableNames["Mooncloth1"][1], "Mooncloth1" },
		{ AtlasLoot_TableNames["Shadoweave1"][1], "Shadoweave1" },
		{ AtlasLoot_TableNames["Spellfire1"][1], "Spellfire1" },
	},
};


